//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
//  
using System;

namespace DelegatesAndEvents
{
	delegate void DelegateCallback();
	class DelegateRemoval
	{
		static void ACallback()
		{
			Console.WriteLine("ACallback()");
		}
		static void BCallback()
		{
			Console.WriteLine("BCallback()");
		}
		static void CCallback()
		{
			Console.WriteLine("CCallback()");
		}
		static void Main(string[] args)
		{
			DelegateCallback ad = new DelegateCallback(ACallback);
			DelegateCallback bd = new DelegateCallback(BCallback);
			DelegateCallback cd = new DelegateCallback(CCallback);

			DelegateCallback dd = ad;
			dd += bd;
			dd += cd;

			DelegateCallback ed = dd;

			Console.WriteLine("Oryginalna lista");
			Delegate [] da = dd.GetInvocationList();
			foreach(Delegate d in da)
			{
				Console.WriteLine("{0} {1}", d.Target, d.Method);
			}
			Console.WriteLine("Skopiowana lista");
			da = ed.GetInvocationList();
			foreach(Delegate d in da)
			{
				Console.WriteLine("{0} {1}", d.Target, d.Method);
			}

			dd = (DelegateCallback)Delegate.Remove(dd, cd);
			da = dd.GetInvocationList();
			Console.WriteLine("Oryginalna lista (po wywoaniu Remove)");
			foreach(Delegate d in da)
			{
				Console.WriteLine("{0} {1}", d.Target, d.Method);
			}
			da = ed.GetInvocationList();
			Console.WriteLine("Skopiowana lista");
			foreach(Delegate d in da)
			{
				Console.WriteLine("{0} {1}", d.Target, d.Method);
			}

		}
	}
}